<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Contact Form Widget .
 *
 */
class tourm_Contact_Form extends Widget_Base {

    public function get_name() {
        return 'tourmcontactform';
    }
    public function get_title() {
        return __( 'Contact Form', 'tourm' );
    }
    public function get_icon() {
        return 'th-icon';
    }
    public function get_categories() {
        return [ 'tourm' ];
    }

    public function get_as_contact_form(){
        if ( ! class_exists( 'WPCF7' ) ) {
            return;
        }
        $as_cfa         = array();
        $as_cf_args     = array( 'posts_per_page' => -1, 'post_type'=> 'wpcf7_contact_form' );
        $as_forms       = get_posts( $as_cf_args );
        $as_cfa         = ['0' => esc_html__( 'Select Form', 'tourm' ) ];
        if( $as_forms ){
            foreach ( $as_forms as $as_form ){
                $as_cfa[$as_form->ID] = $as_form->post_title;
            }
        }else{
            $as_cfa[ esc_html__( 'No contact form found', 'tourm' ) ] = 0;
        }
        return $as_cfa;
    }

    protected function register_controls() {

        $this->start_controls_section(
            'contact_form_section',
            [
                'label'     => __( 'Contact Form', 'tourm' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
            ]
        );

        tourm_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One', 'Style Two'] );

        $this->add_control(
            'tourm_select_contact_form',
            [
                'label'   => esc_html__( 'Select Form', 'tourm' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '0',
                'options' => $this->get_as_contact_form(),
            ]
        );
        // tourm_general_fields( $this, 'title', 'Title', 'TEXT', 'Title', ['2' ] );

        $this->end_controls_section();

        //  $this->start_controls_section(
        //     'general_styling',
        //     [
        //         'label'     => __( 'General Styling', 'tourm' ),
        //         'tab'       => Controls_Manager::TAB_STYLE,
        //     ]
        // );


        // tourm_color_fields( $this, 'form_bg', 'Background', 'background', '{{WRAPPER}} .bg', ['2'] );

        // $this->end_controls_section();

        // tourm_common_style_fields($this, 'title', 'Title', '{{WRAPPER}} .form-title', ['2'], '--white-color');

        //------Button Style-------
        tourm_button_style_fields( $this, '10', 'Button Styling', '{{WRAPPER}} .th-btn' );

    }

    protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == '1' ){
            
            if( !empty($settings['tourm_select_contact_form']) ){
                echo do_shortcode( '[contact-form-7  id="'.$settings['tourm_select_contact_form'].'"]' ); 
            }else{
                echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'tourm' ). '</p></div>';
            }
        }else{
            if( !empty($settings['tourm_select_contact_form']) ){
                echo do_shortcode( '[contact-form-7  id="'.$settings['tourm_select_contact_form'].'"]' ); 
            }else{
                echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'tourm' ). '</p></div>';
            }
        }
    }
}