<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Background;
/**
 * 
 * Newsletter Widget .
 *
 */
class tourm_Newsletter extends Widget_Base {

	public function get_name() {
		return 'tourmnewsletter';
	}
	public function get_title() {
		return __( 'Newsletter', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'layout_section',
			[
				'label'     => __( 'Newsletter Style', 'tourm' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style', ['Style One', 'Style Two', 'Style Three', 'Style Four'] );

		tourm_general_fields( $this, 'title', 'Title', 'TEXT', 'Sign Up For Newsletter' );
		tourm_general_fields( $this, 'note', 'Note Text', 'TEXTAREA2', 'Refer to our Privacy Policy for data management specifics' );


		tourm_general_fields( $this, 'newsletter_placeholder', 'Placeholder', 'TEXT', 'Enter your Email' );
		tourm_general_fields( $this, 'newsletter_button', 'Subscribe Button', 'TEXT', '<i class="fa-solid fa-paper-plane"></i>'  );

		tourm_switcher_fields( $this, 'show_dark', 'Dark?', ['1'] );

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------
		//-------Title Style-------
		tourm_common_style_fields($this, 'title', 'Title', '{{WRAPPER}} .title','','--white-color');

		//-------Description Style-------


	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			echo '<div class="newsletter-area">';
                echo '<div class="newsletter-top">';
                    echo '<div class="row gy-4 align-items-center">';
                        echo '<div class="col-lg-5">';
                            echo '<h2 class="newsletter-title text-white text-capitalize mb-0 title">'.esc_html($settings['title']).'</h2>';
                        echo '</div>';
                        echo '<div class="col-lg-7">';

                        	$class = $settings['show_dark'] == 'yes' ? 'style2' : '';
                        	$btn_class = $settings['show_dark'] == 'yes' ? 'style1' : 'style3';
                        	$icon_class = $settings['show_dark'] == 'yes' ? '2' : '';

                            echo '<form class="newsletter-form '.esc_attr( $class ).'">';
                                echo '<input class="form-control " type="email" placeholder="'.esc_attr( $settings['newsletter_placeholder'] ).'" required="">';
                                echo '<button type="submit" class="th-btn '.esc_attr( $btn_class ).'">'.wp_kses_post( $settings['newsletter_button'] ).' <img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/plane'.esc_html( $icon_class ).'.svg" alt=""></button>';
                            echo '</form>';

                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="cta-area ">';
		        echo '<div class="container">';
		            echo '<div class="row justify-content-center align-items-center">';
		                echo '<div class="col-lg-5 pe-xl-4 ps-xl-4">';
		                    echo '<div class="title-area mb-30 mt-n3 text-center">';
		                        echo '<h2 class="sec-title text-white text-capitalize">'.esc_html($settings['title']).'</h2>';
		                    echo '</div>';
		                    echo '<form class="newsletter-form style3">';
		                        echo '<input class="form-control " type="email" placeholder="'.esc_attr( $settings['newsletter_placeholder'] ).'" required="">';
		                        echo '<button type="submit" class="th-btn style1 btn-fw">'.wp_kses_post( $settings['newsletter_button'] ).' <img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/plane2.svg" alt=""></button>';
		                    echo '</form>';
		                echo '</div>';

		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="newsletter-form-wrapper">';
                echo '<form class="newsletter-form style4">';
                    echo '<input class="form-control " type="email" placeholder="'.esc_attr( $settings['newsletter_placeholder'] ).'" required="">';
                    echo '<button type="submit" class="th-btn style3">'.wp_kses_post( $settings['newsletter_button'] ).'</button>';
                echo '</form>';
            echo '</div>';
		}else{
			echo '<div class="newsletter-sec2">';
                echo '<div class="newsletter-wrapp">';
                    echo '<h2 class="h2 newsletter-title mb-30">'.esc_html($settings['title']).'</h2>';
                echo '</div>';
                echo '<div class="newsletter-form-wrapper">';
                    echo '<form class="newsletter-form style5">';
                        echo '<input class="form-control " type="email" placeholder="'.esc_attr( $settings['newsletter_placeholder'] ).'" required="">';
                        echo '<button type="submit" class="th-btn style3 th-icon">'.wp_kses_post( $settings['newsletter_button'] ).'</button>';
                    echo '</form>';
                echo '</div>';
                echo '<p class="newsletter-text2">'.esc_html($settings['note']).'</p>';
            echo '</div>';
		}
	}
}
						