<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Counter Up Widget .
 *
 */
class tourm_Counterup extends Widget_Base {

	public function get_name() {
		return 'tourmcounterup';
	}
	public function get_title() {
		return __( 'Counter Up', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Counter Up', 'tourm' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two','Style Three','Style Four' ] ); 

		$repeater = new Repeater();

		$fields_to_include = [ 'title' => ['Title','Number', 'After Prefix'] ];
		tourm_repeater_fields( $this, 'counter_lists', 'Counter List', $fields_to_include, ['1','2','3','4'] );

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		$this->start_controls_section(
			'general_styling',
			[
				'label'     => __( 'General', 'tourm' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);


		$this->end_controls_section();

		//-------Number Style-------
		tourm_common_style_fields($this, 'number', 'Number', '{{WRAPPER}} .num',['1','2','3'], '--black-color2');
		tourm_common_style_fields($this, 'number2', 'Number', '{{WRAPPER}} .box-number',['4'], 'color');
		//-------Title Style-------
		tourm_common_style_fields($this, 'title', 'Title', '{{WRAPPER}} .desc');
		

	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			echo '<div class="row">';
				foreach( $settings['counter_lists'] as $data ){
	                echo '<div class="col-sm-6 col-xl-3 counter-card-wrap">';
	                    echo '<div class="counter-card">';
	                        echo '<div class="counter-shape"><span></span></div>';
	                        echo '<div class="media-body">';
	                        	if(!empty($data['number'])){

	                        		$prefix = $data['after_prefix'] ? $data['after_prefix'] : '';
		                            echo '<h3 class="box-number num"><span class="counter-number ">'.esc_html( $data['number'] ).'</span>'.esc_html( $prefix ).'</h3>';
		                        }
		                        if(!empty($data['title'])){
		                            echo '<h6 class="counter-title desc">'.esc_html( $data['title'] ).'</h6>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="counter-box-wrap">';
                foreach( $settings['counter_lists'] as $data ){                
	                echo '<div class="counter-box">';
	                	if(!empty($data['number'])){
		                	$prefix = $data['after_prefix'] ? $data['after_prefix'] : '';
		                    echo '<h2 class="counter-box_number num"><span class="counter-number">'.esc_html( $data['number'] ).'</span>'.esc_html( $prefix ).' </h2>';
		                }
		                if(!empty($data['title'])){
		                    echo '<span class="counter-box_title desc">'.esc_html( $data['title'] ).'</span>';
		                }
	                echo '</div>';
	            }
                
            echo '</div>';
		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="row gy-4 align-items-center justify-content-center">';
				foreach( $settings['counter_lists'] as $data ){
	                echo '<div class="col-md-6 col-xl-3">';
	                    echo '<div class="counter-card style3">';
	                        echo '<div class="counter-shape"><span></span></div>';
	                        echo '<div class="media-body">';
	                            if(!empty($data['number'])){

	                        		$prefix = $data['after_prefix'] ? $data['after_prefix'] : '';
		                            echo '<h3 class="box-number num"><span class="counter-number ">'.esc_html( $data['number'] ).'</span>'.esc_html( $prefix ).'</h3>';
		                        }
		                        if(!empty($data['title'])){
		                            echo '<h6 class="counter-title desc">'.esc_html( $data['title'] ).'</h6>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}else{
			echo '<div class="">';
		        echo '<div class="container">';
		            echo '<div class="counter-sec7">';
		                echo '<div class="row gy-5 align-items-center justify-content-center">';
		                	foreach( $settings['counter_lists'] as $data ){
			                    echo '<div class="col-md-6 col-xl-3">';
			                        echo '<div class="counter-item">';
			                            echo '<div class="counter-shape"></div>';
			                            echo '<div class="media-body">';
			                            	if(!empty($data['number'])){
			                            		$prefix = $data['after_prefix'] ? $data['after_prefix'] : '';

				                                echo '<h3 class="box-number"><span class="counter-number">'.esc_html( $data['number'] ).'</span>'.esc_html( $prefix ).'</h3>';
				                            }
				                            if(!empty($data['title'])){
				                                echo '<h6 class="counter-title desc">'.esc_html( $data['title'] ).'</h6>';
				                            }
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                }

		                    
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}
	}
}